------------------------- ANIMLIB v3 - (c) 2011 Chimecho @ Gcrew - www.gcrew.es -------------------------

anim = {}

function anim.refresh(obj)
	if obj.tim_act:time() >= obj.tim then
		obj.tim_act:reset()
		obj.frame = obj.frame + 1
	end
	if obj.frame > obj.frames then obj.frame = 1 end
	obj.imgs[obj.frame]:rotate(obj.ang)
end

function anim.blit(obj,x,y)
	anim.refresh(obj)
	local w = obj.imgs[obj.frame]:width()
	local h = obj.imgs[obj.frame]:height()
	obj.imgs[obj.frame]:blit(x+w/2,y+h/2)
end

function anim.fxtint(obj,x,y,color)
	anim.refresh(obj)
	local w = obj.imgs[obj.frame]:width()
	local h = obj.imgs[obj.frame]:height()
	image.fxtint(x+w/2,y+h/2,obj.imgs[obj.frame],color)
end

function anim.fxadd(obj,x,y,color)
	anim.refresh(obj)
	local w = obj.imgs[obj.frame]:width()
	local h = obj.imgs[obj.frame]:height()
	image.fxadd(x+w/2,y+h/2,obj.imgs[obj.frame],color)
end

function anim.fxsub(obj,x,y,color)
	anim.refresh(obj)
	local w = obj.imgs[obj.frame]:width()
	local h = obj.imgs[obj.frame]:height()
	image.fxsub(x+w/2,y+h/2,obj.imgs[obj.frame],color)
end

function anim.blend(obj,x,y,alfa)
	anim.refresh(obj)
	local w = obj.imgs[obj.frame]:width()
	local h = obj.imgs[obj.frame]:height()
	image.blend(x+w/2,y+h/2,obj.imgs[obj.frame],alfa)
end

function anim.setframe(obj,frame)
	obj.tim_act:reset()
	obj.frame = math.min(frame,obj.frames)
end

function anim.rotate(obj,ang)
	obj.ang = ang
end

function anim.start(obj)
	obj.tim_act:start()
	obj.stat = "run"
end

function anim.pause(obj)
	obj.tim_act:reset()
	obj.tim_act:stop()
	obj.stat = "stop"
end

function anim.reset(obj)
	obj.tim_act:reset()
	if obj.stat=="stop" or obj.stat=="end" then
		obj.tim_act:stop()
	end
	obj.frame = 1
end

function anim.currentframe(obj)
	return obj.frame
end

function anim.free(obj)
	for i=1,#obj.imgs do
		obj.imgs[i]:free()
	end
end

function anim.create(imgs, w, h, tiempo) -- tabla con imagenes, tiempo entre cuadro y cuadro en milisegundos
	local args = 4
	local tiempo = tiempo
	if type(imgs)=="table" then tiempo = w; args = 2 end
	
	animobj = {w=0, h=0, blit = anim.blit, fxtint = anim.fxtint, fxadd = anim.fxadd, fxsub = anim.fxsub, blend = anim.blend, rotate = anim.rotate, setframe = anim.setframe, start = anim.start, pause = anim.pause, reset = anim.reset, currentframe = anim.currentframe, free = anim.free, ang = 0, frame = 1, frames = 0, imgs = {}, tim = tiempo, tim_act = timer.new(), state="stop"}
	
	if args == 2 then -- anim.create(imgs,tiempo)
		animobj.imgs = imgs
	elseif args == 4 then -- anim.create(spritesheet o ruta,w,h,tiempo)
		if type(imgs) == "string" then
			imgs = image.load(imgs)
		end
		local indice = 1
		local cw = math.floor(imgs:realwidth()/w)
		local ch = math.floor(imgs:realheight()/h)
		for j=1,ch do
			for i = 1,cw do
				animobj.imgs[indice] = image.create(w,h,0x0)
				animobj.imgs[indice]:blit(0,0,imgs,(i-1)*w,(j-1)*h,w,h)
				indice = indice + 1
			end
		end
		imgs:free()
	end
	
	animobj.w = animobj.imgs[1]:realwidth()
	animobj.h = animobj.imgs[1]:realheight()
	animobj.frames = #animobj.imgs
	animobj.tim_act:reset()
	animobj.tim_act:stop()
	return animobj
end